using System;
using System.Text;

class Solution
{
    static void Main()
    {
        string prvi = Console.ReadLine();
        if (prvi == null) return;
        string[] p0 = prvi.Split(new[]{' ', '\t'}, StringSplitOptions.RemoveEmptyEntries);
        int n = int.Parse(p0[0]);
        long W = long.Parse(p0[1]);
        double eps = double.Parse(p0[2], System.Globalization.CultureInfo.InvariantCulture);

        long[] tezine = new long[n];
        long[] vrednosti = new long[n];
        for (int i = 0; i < n; i++)
        {
            string linija = Console.ReadLine();
            string[] del = linija.Split(new[]{' ', '\t'}, StringSplitOptions.RemoveEmptyEntries);
            tezine[i] = long.Parse(del[0]);
            vrednosti[i] = long.Parse(del[1]);
        }

        long Vmax = 0;
        for (int i = 0; i < n; i++) if (vrednosti[i] > Vmax) Vmax = vrednosti[i];

        if (Vmax == 0)
        {
            Console.WriteLine("0");
            Console.WriteLine();
            return;
        }

        double Kd = eps * (double)Vmax / (double)n;
        if (Kd < 1e-9) Kd = 1e-9;
        int[] skal = new int[n];
        long sumSkal = 0;
        for (int i = 0; i < n; i++)
        {
            long v = vrednosti[i];
            int s = (int)(v / Kd);
            if (s < 0) s = 0;
            skal[i] = s;
            sumSkal += s;
        }

        if (sumSkal == 0)
        {
           
            int najlepsi = -1;
            long bestV = -1;
            for (int i = 0; i < n; i++)
            {
                if (tezine[i] <= W && vrednosti[i] > bestV)
                {
                    bestV = vrednosti[i];
                    najlepsi = i;
                }
            }
            if (najlepsi == -1)
            {
                Console.WriteLine("0");
                Console.WriteLine();
            }
            else
            {
                Console.WriteLine("1");
                Console.WriteLine((najlepsi + 1).ToString());
            }
            return;
        }

        int S = (int)sumSkal;
        long INF = (1L << 62);

        long[] dp = new long[S + 1];
        for (int i = 1; i <= S; i++) dp[i] = INF;
        int[] last = new int[S + 1]; 
        for (int i = 0; i <= S; i++) last[i] = 0;

        for (int i = 0; i < n; i++)
        {
            int si = skal[i];
            if (si == 0) continue;
            long wi = tezine[i];
            for (int val = S; val >= si; val--)
            {
                long prev = dp[val - si];
                if (prev == INF) continue;
                long nw = prev + wi;
                if (nw < dp[val])
                {
                    dp[val] = nw;
                    last[val] = i + 1; 
                }
            }
        }

        int bestVal = 0;
        for (int v = 0; v <= S; v++)
        {
            if (dp[v] <= W && v > bestVal) bestVal = v;
        }

        if (bestVal == 0)
        {
            
            int najbolje = -1;
            long bv = -1;
            for (int i = 0; i < n; i++)
            {
                if (tezine[i] <= W && vrednosti[i] > bv)
                {
                    bv = vrednosti[i];
                    najbolje = i;
                }
            }
            if (najbolje == -1)
            {
                Console.WriteLine("0");
                Console.WriteLine();
                return;
            }
            Console.WriteLine("1");
            Console.WriteLine((najbolje + 1).ToString());
            return;
        }

        System.Collections.Generic.List<int> izabrani = new System.Collections.Generic.List<int>();
        int cur = bestVal;
        while (cur > 0)
        {
            int it = last[cur];
            if (it == 0) break;
            izabrani.Add(it);
            int idx = it - 1;
            cur -= skal[idx];
        }

        Console.WriteLine(izabrani.Count);
        if (izabrani.Count > 0)
        {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < izabrani.Count; i++)
            {
                if (i > 0) sb.Append(' ');
                sb.Append(izabrani[i]);
            }
            Console.WriteLine(sb.ToString());
        }
        else Console.WriteLine();
    }
}